﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

using System.Collections.Generic;

public partial class LINQ_to_Objects : System.Web.UI.Page
{
    List<Osoba> listaOsob = new List<Osoba> 
    { 
        new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 35 }, 
        new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 246813579, Wiek = 36 },
        new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", NumerTelefonu = 567891234, Wiek = 7 }, 
        new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 987654321, Wiek = 2 } 
    };

    protected void Page_Load(object sender, EventArgs e)
    {
        {
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select osoba;
            string s = "<FONT COLOR='navy'>Lista osób pełnoletnich:</FONT><BR>";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "<BR>";
            Label1.Text = s;
            
            s = "<FONT COLOR='navy'>Kalkulacje:</FONT><BR>";
            s += "Wiek najstarszej osoby: " + listaOsobPelnoletnich.Max(osoba => osoba.Wiek) + "<BR>";
            s += "Średni wiek osób pełnoletnich: " + listaOsobPelnoletnich.Average(osoba => osoba.Wiek) + "<BR>";
            s += "Suma lat osób pełnoletnich: " + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek) + "<BR>";
            Label2.Text = s;

            var najstarszaOsoba = listaOsobPelnoletnich.Single(osoba1 => (osoba1.Wiek == listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            s = "<FONT COLOR='navy'>Najstarsza osoba:</FONT> " + najstarszaOsoba.Imię + " " + najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")<BR>";
            Label3.Text = s;
        }

        {
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            var listaKobiet = from osoba in listaOsob
                              where osoba.Imię.EndsWith("a")
                              select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };

            string s = "<FONT COLOR='navy'>Łączenie zbiorów danych:</FONT><BR>";
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Union(listaKobiet);
            s += "<BR>Lista osób pełnoletnich lub kobiet (suma zbiorów):<BR>";
            foreach (var osoba in listaPelnoletnich_I_Kobiet) s += osoba.Imię + " " + osoba.Nazwisko + "<BR>";
            
            //czesc wspolna
            var listaKobietPelnoletnich = listaOsobPelnoletnich.Intersect(listaKobiet);
            s += "<BR>Lista pełnoletnich kobiet (część wspólna zbiorów):<BR>";
            foreach (var osoba in listaKobietPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "<BR>";

            //roznica
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich.Except(listaKobiet);
            s += "<BR>Lista osób pełnoletnich nie będących kobietami (różnica zbiorów):<BR>";
            foreach (var osoba in listaPelnoletnichNiekobiet) s += osoba.Imię + " " + osoba.Nazwisko + "<BR>";
            Label4.Text = s;

            var listaTelefonów = from osoba in listaOsob select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in listaOsob select new { osoba.Id, osoba.Imię, osoba.Nazwisko };
            var listaPersonaliówZTelefonami = from telefon in listaTelefonów join personalia in listaPersonaliów on telefon.Id equals personalia.Id select new { telefon.Id, personalia.Imię, personalia.Nazwisko, telefon.NumerTelefonu };
            s = "<FONT COLOR='navy'>Pobieranie danych z dwóch źródeł - operator join:</FONT><BR>";
            foreach (var osoba in listaPersonaliówZTelefonami) s += osoba.Imię + " " + osoba.Nazwisko + " " + osoba.NumerTelefonu + "<BR>";
            Label5.Text = s;
        }
    }
}

class Osoba
{
    public int Id;
    public string Imię, Nazwisko;
    public int NumerTelefonu;
    public int Wiek;
}
